PROGRAM test
!
!  Purpose: 
!    To illustrate the use of an internal procedure.
! 
!  Record of revisions:
!       Date       Programmer          Description of change
!       ====       ==========          =====================
!     12/28/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! Declare parameters:
INTEGER, PARAMETER :: single = KIND(0.0)    ! Single precision
REAL(KIND=single), PARAMETER :: pi = 3.141592

! Declare local variables:
REAL(kind=single) :: theta               ! Angle in degrees

! Get desired angle
WRITE (*,*) 'Enter desired angle in degrees: ' 
READ (*,*) theta

! Calculate and display the result.
WRITE (*,'(A,F10.4)') ' The secant is ', secant(theta)

! Note that the WRITE above was the last executable statement.
! Now, declare internal procedure secant:
CONTAINS
   REAL FUNCTION secant(angle_in_degrees)
   !
   !  Purpose:
   !    To calculate the secant of an angle in degrees.
   !
   REAL(KIND=single) angle_in_degrees

   ! Calculate secant
   secant = 1. / cos( angle_in_degrees * pi / 180. )

   END FUNCTION secant

END PROGRAM test
